<!DOCTYPE html>
<html>
<head>
<meta charset="utf-8">
<title>Requirements Check</title>

<style>
/* — STYLE GLOBAL — */
body { margin:0; padding:0; font-family:"Inter",Arial,sans-serif; background:#f4f4f7; display:flex; align-items:center; justify-content:center; min-height:100vh; }
.install-wrapper { width:100%; max-width:700px; background:white; padding:40px; border-radius:16px; box-shadow:0 6px 30px rgba(0,0,0,0.10); text-align:center; }
.install-title { font-size:28px; font-weight:700; margin-bottom:20px; color:#111827; }
.install-text { font-size:17px; color:#4b5563; margin:15px 0 25px; }
.install-btn { display:inline-block; background:#4f46e5; color:white; padding:14px 28px; border-radius:10px; font-size:17px; text-decoration:none; transition:0.2s; }
.install-btn:hover { background:#4338ca; }
.install-list { text-align:left; margin-top:20px; color:#374151; font-size:15px; }
</style>

</head>
<body>

<div class="install-wrapper">

    <h1 class="install-title">System Requirements</h1>

    <p class="install-text">
        {{ $allPassed ? "All requirements passed successfully." : "Some requirements need to be fixed." }}
    </p>

    <div class="install-list">
        @foreach($results as $groupName => $group)
            <p><strong>{{ ucfirst($groupName) }}</strong> —
                @if($group['allPassed'])
                    <span style="color:#22c55e">OK</span>
                @else
                    <span style="color:#dc2626">❌ Error</span>
                @endif
            </p>

            @if(!$group['allPassed'])
                @foreach($group['items'] as $item)
                    @if(!$item['passes'])
                        <p style="color:#dc2626; margin-left:20px;">• {!! $item['errorMessage'] !!}</p>
                    @endif
                @endforeach
            @endif

        @endforeach
    </div>

    <br>
    <a class="install-btn" href="{{ $allPassed ? url('install/database') : url('install/requirements') }}">
        {{ $allPassed ? 'Continue' : 'Check again' }}
    </a>

</div>

</body>
</html>
