<!DOCTYPE html>
<html>
<head>
<meta charset="utf-8">
<title>Create Admin</title>

<style>
/* GLOBAL STYLE */
body { margin:0; padding:0; font-family:"Inter",Arial,sans-serif; background:#f4f4f7; display:flex; align-items:center; justify-content:center; min-height:100vh; }
.install-wrapper { width:100%; max-width:700px; background:white; padding:40px; border-radius:16px; box-shadow:0 6px 30px rgba(0,0,0,0.10); text-align:center; }
.install-title { font-size:28px; font-weight:700; margin-bottom:20px; color:#111827; }
.install-text { font-size:17px; color:#4b5563; margin:15px 0 25px; }
.install-btn { display:inline-block; background:#4f46e5; color:white; padding:14px 28px; border-radius:10px; font-size:17px; text-decoration:none; transition:0.2s; }
.install-btn:hover { background:#4338ca; }
.install-error { background:#dc2626; color:white; padding:12px; border-radius:10px; margin-bottom:20px; }
.input-field { width:100%; padding:12px; border:1px solid #d1d5db; border-radius:10px; margin-bottom:15px; }
</style>

</head>
<body>

<div class="install-wrapper">

    <h1 class="install-title">Create Admin Account</h1>

    <p class="install-text">Enter the credentials for your super admin.</p>

    @if($errors->hasAny())
        <div class="install-error">{{ $errors->first() }}</div>
    @endif

    <form action="{{ url('install/admin/validate') }}" method="post">
        @csrf

        <input class="input-field" type="email" name="email" placeholder="Admin email" value="{{ old('email') }}" required>
        <input class="input-field" type="password" name="password" placeholder="Admin password" required>
        <input class="input-field" type="password" name="password_confirmation" placeholder="Confirm password" required>

        <button class="install-btn" type="submit">Continue</button>
    </form>

</div>

</body>
</html>
